# 分页

我们有如下订单表：

```mysql
create table orders
(
    id          serial primary key,
    product_id  integer,
    order_date  date default now(),
    quantity    integer,
    customer_id integer
);
```

现在开发人员希望查询指定的某一天内的数据，并按每一百条一页查询，那么正确的语句应该是：

## 答案

```mysql
select id, product_id, order_date, quantity, customer_id
from orders
where date = $1
offset $2 limit 100; 
```

## 选项

### 缺少 limit

```mysql
select id, product_id, order_date, quantity, customer_id
from orders
where date = $1
offset $2; 
```

### 缺少 offset

```mysql
select id, product_id, order_date, quantity, customer_id
from orders
where date = $1; 
```

### 结构不对

```mysql
select id, product_id, order_date, quantity, customer_id
from orders
where date = $1 and
offset $2 and limit 100; 
```
